within AixLib.Media.Refrigerants;
package UsersGuide "User's Guide"
  extends Modelica.Icons.Information;


  annotation(DocumentationClass = true, Documentation(info="<html><p>
  This library provides different refrigerant models that are used, for
  example, in heat pumps or chillers. The objectives of these
  refrigerant models are both to provide an accurate description of
  thermodynamic properties and to provide fast models to speed up the
  overall simulation time of complex simulation models.
</p>
<p>
  In the following User's Guide, a short summary of the refrigerants'
  library is given to allow the user an easy use of the refrigerant
  models.
</p>
<ol>
  <li>
    <a href=
    \"modelica://AixLib.Media.Refrigerants.UsersGuide.Composition\">Composition
    of the library</a>
  </li>
  <li>
    <a href=
    \"modelica://AixLib.Media.Refrigerants.UsersGuide.Approaches\">Approaches
    implemented</a>
  </li>
  <li>
    <a href=
    \"modelica://AixLib.Media.Refrigerants.UsersGuide.Naming\">Naming and
    abbreviations</a>
  </li>
  <li>
    <a href=
    \"modelica://AixLib.Media.Refrigerants.UsersGuide.References\">References</a>
  </li>
</ol>
<p>
  Additionally, descriptions of all models are provided in each models
  information section.
</p>
<ul>
  <li>October 14, 2017, by Mirko Engelpracht, Christian Vering:<br/>
    First implementation (see <a href=
    \"https://github.com/RWTH-EBC/AixLib/issues/408\">issue 408</a>).
  </li>
</ul>
</html>"));
end UsersGuide;
